function [time,precip,dropbin,dropmat] = ImportingVDisRain()

cd('E:\Google Drive\Projects\HI-SCALE SGP\Data\ARM_Data\Video Disdrometer');

currdir = dir;

time = [];
precip = [];
dropmat = [];
for i = 1:length(currdir)
	
	cdfflag = strfind(currdir(i).name,'.cdf');
	
	if isempty(cdfflag)
		continue
	end
	
	
	%% Importing Time
	%year index
	yi = strfind(currdir(i).name,'.2016');
	
	start_time = datetime(currdir(i).name(yi+1:yi+8),'InputFormat','yyyyMMdd');
	offset_time = ncread(currdir(i).name,'time');
	
	vec_time = repmat(start_time,length(offset_time),1);
	vec_time = datevec(vec_time);
	
	currtime = vec_time;
	currtime(:,6) = currtime(:,6) + offset_time;
	currtime = datetime(currtime);
	
	%% Importing Rain Data
	currprecip_mean = ncread(currdir(i).name,'rain_rate');
	currdropmat = ncread(currdir(i).name,'num_drops');
	currdropmat = currdropmat';
	dropbin = ncread(currdir(i).name,'drop_diameter');
	
	time = [time ; currtime];
	precip = [precip ; currprecip_mean];
	dropmat = [dropmat ; currdropmat];
	
	
end

end

